/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.jpqleditor.ui;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;

public class ReflectionInfo
implements Comparable<ReflectionInfo> {
    private final Integer index;
    private final String propertyName;

    private ReflectionInfo(Integer index, String propertyName) {
        this.index = index;
        this.propertyName = propertyName;
    }

    public Integer getIndex() {
        return this.index;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String toString() {
        return "{" + this.index + ", " + this.propertyName + "}";
    }

    @Override
    public int compareTo(ReflectionInfo o) {
        if (this.index != o.index) {
            if (this.index == null) {
                return -1;
            }
            if (o.index == null) {
                return 1;
            }
            int result = this.index.compareTo(o.index);
            if (result != 0) {
                return result;
            }
        }
        if (this.propertyName != o.propertyName) {
            if (this.propertyName == null) {
                return -1;
            }
            if (o.propertyName == null) {
                return 1;
            }
            return this.propertyName.compareTo(o.propertyName);
        }
        return 0;
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + Objects.hashCode(this.index);
        hash = 79 * hash + Objects.hashCode(this.propertyName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReflectionInfo other = (ReflectionInfo)obj;
        if (!Objects.equals(this.propertyName, other.propertyName)) {
            return false;
        }
        return Objects.equals(this.index, other.index);
    }

    public static List<ReflectionInfo> prepare(List<? extends Object> data) throws IntrospectionException {
        Integer rowLength = null;
        for (Object object : data) {
            if (object instanceof Object[]) {
                if (rowLength != null) {
                    if (rowLength == ((Object[])object).length) continue;
                    rowLength = null;
                    break;
                }
                rowLength = ((Object[])object).length;
                continue;
            }
            rowLength = null;
            break;
        }
        TreeSet<ReflectionInfo> resultPrecursor = new TreeSet<ReflectionInfo>();
        for (Object object : data) {
            if (rowLength != null) {
                Object[] rowArray = (Object[])object;
                for (int i = 0; i < rowLength; ++i) {
                    resultPrecursor.addAll(ReflectionInfo.fromObject(i, rowArray[i]));
                }
                continue;
            }
            resultPrecursor.addAll(ReflectionInfo.fromObject(null, object));
        }
        return new ArrayList<ReflectionInfo>(resultPrecursor);
    }

    private static List<ReflectionInfo> fromObject(Integer index, Object obj) throws IntrospectionException {
        if (obj == null || obj.getClass().getName().startsWith("java.lang") || obj.getClass().getName().startsWith("java.math")) {
            return Collections.singletonList(new ReflectionInfo(index, null));
        }
        BeanInfo bi = Introspector.getBeanInfo(obj.getClass(), Object.class);
        ArrayList<ReflectionInfo> result = new ArrayList<ReflectionInfo>();
        for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
            result.add(new ReflectionInfo(index, pd.getName()));
        }
        if (result.isEmpty()) {
            return Collections.singletonList(new ReflectionInfo(index, null));
        }
        return result;
    }
}

